<?php

namespace MyHomeCore\Common;


/**
 * Class Translations
 * @package MyHomeCore\Common
 */
class Translations {

	/**
	 * @return array
	 */
	public static function get_contact_form() {
		return array(
			'email'         => wp_kses( __( 'Email', 'myhome-core' ), array() ),
			'phone'         => wp_kses( __( 'Phone', 'myhome-core' ), array() ),
			'message'       => wp_kses( __( 'Your message', 'myhome-core' ), array() ),
			'send'          => wp_kses( __( 'Send', 'myhome-core' ), array() ),
			'msg_to_short'  => wp_kses( __( 'Message is to short (min 5 characters) ', 'myhome-core' ), array() ),
			'email_invalid' => wp_kses( __( 'Email address is invalid', 'myhome-core' ), array() ),
			'msg_error'     => wp_kses( __( 'Error...', 'myhome-core' ), array() ),
			'msg_success'   => wp_kses( __( 'Your message was sent successfully. Thanks.', 'myhome-core' ), array() ),
			'sending'       => wp_kses( __( 'Sending...', 'myhome-core' ), array() )
		);
	}

	/**
	 * @return array
	 */
	public static function get_frontend() {
		return array(
			'username'          => wp_kses( __( 'Username', 'myhome-core' ), array() ),
			'accept'            => wp_kses( __( 'I agree to the', 'myhome-core' ), array() ),
			'terms_of_service'  => wp_kses( __( 'Terms of Service', 'myhome-core' ), array() ),
			'alphabetically'    => wp_kses( __( 'Alphabetical', 'myhome-core' ), array() ),
			'compare'           => wp_kses( __( 'Compare', 'myhome-core' ), array() ),
			'added'             => wp_kses( __( 'Added', 'myhome-core' ), array() ),
			'details'           => wp_kses( __( 'Details', 'myhome-core' ), array() ),
			'more'              => wp_kses( __( 'More', 'myhome-core' ), array() ),
			'newest'            => wp_kses( __( 'Newest', 'myhome-core' ), array() ),
			'sort_by'           => wp_kses( __( 'Sort by:', 'myhome-core' ), array() ),
			'popular'           => wp_kses( __( 'Popular', 'myhome-core' ), array() ),
			'price'             => wp_kses( __( 'Price', 'myhome-core' ), array() ),
			'reset'             => wp_kses( __( 'Reset', 'myhome-core' ), array() ),
			'full_screen'       => wp_kses( __( 'Full Screen', 'myhome-core' ), array() ),
			'price_high_to_low' => wp_kses( __( 'Price (high to low)', 'myhome-core' ), array() ),
			'price_low_to_high' => wp_kses( __( 'Price (low to high)', 'myhome-core' ), array() ),
			'results'           => wp_kses( __( 'results', 'myhome-core' ), array() ),
			'found'             => wp_kses( __( 'Found', 'myhome-core' ), array() ),
			'any'               => wp_kses( __( 'Any', 'myhome-core' ), array() ),
			'search'            => wp_kses( __( 'Search', 'myhome-core' ), array() ),
			'from'              => wp_kses( __( 'From', 'myhome-core' ), array() ),
			'to'                => wp_kses( __( 'To', 'myhome-core' ), array() ),
			'advanced'          => wp_kses( __( 'Advanced', 'myhome-core' ), array() ),
			'hide_advanced'     => wp_kses( __( 'Hide', 'myhome-core' ), array() ),
			'clear'             => wp_kses( __( 'clear', 'myhome-core' ), array() ),
			'street_view'       => wp_kses( __( 'Street View', 'myhome-core' ), array() ),
			'prev'              => wp_kses( __( 'Prev', 'myhome-core' ), array() ),
			'next'              => wp_kses( __( 'Next', 'myhome-core' ), array() ),
			'fullscreen'        => wp_kses( __( 'Full screen', 'myhome-core' ), array() ),
			'fullscreen_close'  => wp_kses( __( 'Close full screen', 'myhome-core' ), array() ),
			'clear_search'      => wp_kses( __( 'Clear search', 'myhome-core' ), array() ),
			'no_results'        => wp_kses( __( 'No results found', 'myhome-core' ), array() ),
			'hide'              => wp_kses( __( 'Hide', 'myhome-core' ), array() ),
			'show'              => wp_kses( __( 'Show', 'myhome-core' ), array() ),
			'attributes'        => wp_kses( __( 'Attributes', 'myhome-core' ), array() ),
			'show_location'     => wp_kses( __( 'Show location', 'myhome-core' ), array() ),
			'near'              => wp_kses( __( 'Show near', 'myhome-core' ), array() ),
			'login'             => wp_kses( __( 'Login', 'myhome-core' ), array() ),
			'login2'            => apply_filters( 'myhome_panel_login_string', wp_kses( __( 'Login', 'myhome-core' ), array() ) ),
			'register'          => wp_kses( __( 'Register', 'myhome-core' ), array() ),
			'submit_property'   => wp_kses( __( 'Submit property', 'myhome-core' ), array() ),
			'my_properties'     => wp_kses( __( 'My properties', 'myhome-core' ), array() ),
			'edit_profile'      => wp_kses( __( 'Edit profile', 'myhome-core' ), array() ),
			'view_profile'      => wp_kses( __( 'View my profile', 'myhome-core' ), array() ),
			'log_out'           => wp_kses( __( 'Log out', 'myhome-core' ), array() ),
			'currency'          => wp_kses( __( 'Currency', 'myhome-core' ), array() ),
			'enter_login'       => wp_kses( __( 'Enter your login ', 'myhome-core' ), array() ),
			'enter_password'    => wp_kses( __( 'Enter your password', 'myhome-core' ), array() ),
			'retrieve_password' => wp_kses( __( 'reset password', 'myhome-core' ), array() ),
			'save_this_search'  => wp_kses( __( 'Save this search', 'myhome-core' ), array() ),
			'agents'            => wp_kses( __( 'Agents', 'myhome-core' ), array() ),
			'hello'             => wp_kses( __( 'Hello', 'myhome-core' ), array() ),
			'reg_completed'     => wp_kses( __( 'Registration completed. Thank you!', 'myhome-core' ), array() ),
			'check_email'       => wp_kses( __( 'Please check your email to activate your account', 'myhome-core' ), array() ),
			'back'              => wp_kses( __( 'back', 'myhome-core' ), array() ),
			'email_required'    => wp_kses( __( 'Email field is required', 'myhome-core' ), array() ),
			'enter_email'       => wp_kses( __( 'Please enter your email address to request a password reset.', 'myhome-core' ), array() ),
			'reset_password'    => wp_kses( __( 'Reset Password', 'myhome-core' ), array() ),
			'ok'                => wp_kses( __( 'OK', 'myhome-core' ), array() ),
			'exclamation_mark'  => wp_kses( __( '!', 'myhome-core' ), array() ),
			'no_user'           => wp_kses( __( 'If your email address exists in our database, you will receive a password recovery link at your email address in a few minutes.', 'myhome-core' ), array() ),
			'password'          => wp_kses( __( 'Password', 'myhome-core' ), array() ),
			'email'             => wp_kses( __( 'Email', 'myhome-core' ), array() ),
			'repeat_password'   => wp_kses( __( 'Repeat password', 'myhome-core' ), array() ),
			'password_mismatch' => wp_kses( __( 'Password mismatch', 'myhome-core' ), array() ),
			'account_type'      => wp_kses( __( 'Account type', 'myhome-core' ), array() ),
			'connect_with'      => wp_kses( __( 'Connect with', 'myhome-core' ), array() ),
			'saved_success'     => wp_kses( __( 'Saved successfully', 'myhome-core' ), array() ),
			'saving'            => wp_kses( __( 'Saving...', 'myhome-core' ), array() ),
			'save_search'       => wp_kses( __( 'Save search', 'myhome-core' ), array() ),
			'name_required'     => wp_kses( __( 'Name field is required', 'myhome-core' ), array() ),
			'save'              => wp_kses( __( 'Save', 'myhome-core' ), array() ),
			'enter_s_name'      => wp_kses( __( 'Enter search name', 'myhome-core' ), array() ),
			'removed'           => wp_kses( __( 'Removed', 'myhome-core' ), array() ),
			'added_to_favorite' => wp_kses( __( 'Added to favorite', 'myhome-core' ), array() ),
			'add_to_favorite'   => wp_kses( __( 'Add to favorite', 'myhome-core' ), array() ),
			'favorite'          => wp_kses( __( 'Favorite', 'myhome-core' ), array() ),
			'saved_searches'    => wp_kses( __( 'Saved searches', 'myhome-core' ), array() ),
			'add_to_compare'    => wp_kses( __( 'Add to compare', 'myhome-core' ), array() ),
			'added_to_compare'  => wp_kses( __( 'Added to compare', 'myhome-core' ), array() ),
		);
	}

	public static function get_backend() {
		return array(
			'use_for_registration'              => wp_kses( __( 'Use for the registration form', 'myhome-core' ), array() ),
			'property_field_type'               => wp_kses( __( 'Important information: Property type field can\'t be multi-select, because it has special feature to "hide other fields". Read more how to make unnecessary search form filters disappear after changing Property Type: ', 'myhome-core' ), array() ),
			'required_breadcrumbs'              => wp_kses( __( 'This field is a part of the breadcrumbs and is required by the URL structure. If you do not wish to make it required, please remove it from the breadcrumbs in the MyHome Theme / Breadcrumbs. Fields that are part of breadcrumbs also cannot be multiple choice because it will break url structure.', 'myhome-core' ), array() ),
			'id'                                => wp_kses( __( 'ID', 'myhome-core' ), array() ),
			'internal_id'                       => wp_kses( __( 'Internal ID', 'myhome-core' ), array() ),
			'delete_are_you_sure'               => wp_kses( __( 'Are you sure you want to delete this field?', 'myhome-core' ), array() ),
			'set_icon'                          => wp_kses( __( 'Icon', 'myhome-core' ), array() ),
			'set_icon_description'              => wp_kses( __( 'It will be displayed on the property cards and single property page instead of text label', 'myhome-core' ), array() ),
			'start_typing'                      => wp_kses( __( 'Start typing or click here', 'myhome-core' ), array() ),
			'edit'                              => wp_kses( __( 'Edit', 'myhome-core' ), array() ),
			'edit_searchform'                   => wp_kses( __( 'Edit search form', 'myhome-core' ), array() ),
			'delete'                            => wp_kses( __( 'Delete', 'myhome-core ' ), array() ),
			'name'                              => wp_kses( __( 'Name', 'myhome-core ' ), array() ),
			'count'                             => wp_kses( __( 'Popular', 'myhome-core ' ), array() ),
			'type'                              => wp_kses( __( 'Type', 'myhome-core' ), array() ),
			'search_form_edit'                  => wp_kses( __( 'Edit', 'myhome-core' ), array() ),
			'slug'                              => wp_kses( __( 'Slug', 'myhome-core' ), array() ),
			'required'                          => wp_kses( __( 'Required', 'myhome-core' ), array() ),
			'separate'                          => wp_kses( __( '- separate with commas' ), array() ),
			'yes'                               => wp_kses( __( 'Yes', 'myhome-core' ), array() ),
			'no'                                => wp_kses( __( 'No', 'myhome-core' ), array() ),
			'save'                              => wp_kses( __( 'Save', 'myhome-core' ), array() ),
			'hide'                              => wp_kses( __( 'Hide', 'myhome-core' ), array() ),
			'search_form_control'               => wp_kses( __( 'Search form - display as:', 'myhome-core' ), array() ),
			'select'                            => wp_kses( __( 'Drop-down list', 'myhome-core' ), array() ),
			'select_range'                      => wp_kses( __( 'Drop-down list based on a range ( from - to )', 'myhome-core' ), array() ),
			'select_multiple'                   => wp_kses( __( 'Drop-down list - multiple select', 'myhome-core' ), array() ),
			'text'                              => wp_kses( __( 'Input Text', 'myhome-core' ), array() ),
			'text_range'                        => wp_kses( __( 'Input field based on a range ( from - to )', 'myhome-core' ), array() ),
			'checkbox'                          => wp_kses( __( 'Checkbox', 'myhome-core' ), array() ),
			'radio_button'                      => wp_kses( __( 'Left/right: radio button || top/bottom - drop-down list', 'myhome-core' ), array() ),
			'all'                               => wp_kses( __( 'All existing values', 'myhome-core' ), array() ),
			'most_popular'                      => wp_kses( __( 'Most popular', 'myhome-core' ), array() ),
			'static'                            => wp_kses( __( 'Static values', 'myhome-core' ), array() ),
			'default_values'                    => wp_kses( __( 'Default values', 'myhome-core' ), array() ),
			'most_popular_limit'                => wp_kses( __( 'Most popular limit', 'myhome-core' ), array() ),
			'add'                               => wp_kses( __( 'Add', 'myhome-core' ), array() ),
			'value'                             => wp_kses( __( 'Value', 'myhome-core' ), array() ),
			'basic'                             => wp_kses( __( 'Basic', 'myhome-core' ), array() ),
			'advanced'                          => wp_kses( __( 'Advanced', 'myhome-core' ), array() ),
			'suggestions_show'                  => wp_kses( __( 'Show suggestions', 'myhome-core' ), array() ),
			'card_show_label'                   => wp_kses( __( 'Display on property card', 'myhome-core' ), array() ),
			'property_show_label'               => wp_kses( __( 'Display on single property page', 'myhome-core' ), array() ),
			'placeholder'                       => wp_kses( __( 'Placeholder', 'myhome-core' ), array() ),
			'placeholder_from'                  => wp_kses( __( 'Placeholder from', 'myhome-core' ), array() ),
			'placeholder_to'                    => wp_kses( __( 'Placeholder to', 'myhome-core' ), array() ),
			'use_as_tags'                       => wp_kses( __( 'Use as tags', 'myhome-core' ), array() ),
			'property_show_link'                => wp_kses( __( 'Single property page: show as link', 'myhome-core' ), array() ),
			'display_full_width'                => wp_kses( __( 'Search Form - display full width', 'myhome-core' ), array() ),
			'new_box_label'                     => wp_kses( __( 'Single property page: display in a separate section', 'myhome-core' ), array() ),
			'parent_attribute'                  => wp_kses( __( 'Parent attribute', 'myhome-core' ), array() ),
			'no_parent_attribute'               => wp_kses( __( 'No parent attribute', 'myhome-core' ), array() ),
			'number_operator'                   => wp_kses( __( 'Number operator', 'myhome-core' ), array() ),
			'success'                           => wp_kses( __( 'Success', 'myhome-core' ), array() ),
			'error'                             => wp_kses( __( 'Error', 'myhome-core' ), array() ),
			'saving_changes'                    => wp_kses( __( 'Saving changes', 'myhome-core' ), array() ),
			'are_you_sure'                      => wp_kses( __( 'Are you sure?', 'myhome-core' ), array() ),
			'something_went_wrong'              => wp_kses( __( 'Something went wrong during fields order update.', 'myhome-core' ), array() ),
			'text_field'                        => wp_kses( __( 'Text field', 'myhome-core' ), array() ),
			'number_field'                      => wp_kses( __( 'Number field', 'myhome-core' ), array() ),
			'widgets_field'                     => wp_kses( __( 'Widgets field', 'myhome-core' ), array() ),
			'text_area_field'                   => wp_kses( __( 'Text area field', 'myhome-core' ), array() ),
			'create_field'                      => wp_kses( __( 'Create field', 'myhome-core' ), array() ),
			'field_name'                        => wp_kses( __( 'Field name', 'myhome-core' ), array() ),
			'field_type'                        => wp_kses( __( 'Field type', 'myhome-core' ), array() ),
			'search_attributes'                 => wp_kses( __( 'Search form attributes', 'myhome-core' ), array() ),
			'additional_attributes'             => wp_kses( __( 'Additional attributes', 'myhome-core' ), array() ),
			'field_is_required'                 => wp_kses( __( 'Required (for frontend panel)', 'myhome-core' ), array() ),
			'field_is_link'                     => wp_kses( __( 'Link', 'myhome-core' ), array() ),
			'create'                            => wp_kses( __( 'Create', 'myhome-core' ), array() ),
			'create_new'                        => wp_kses( __( 'Create new search form', 'myhome-core' ), array() ),
			'search_form_name'                  => wp_kses( __( 'Search form name', 'myhome-core' ), array() ),
			'cant_empty'                        => wp_kses( __( 'Can\'t be empty', 'myhome-core' ), array() ),
			'choose_search_form'                => wp_kses( __( 'Choose search form to edit', 'myhome-core' ), array() ),
			'searchforms_description'           => wp_kses( __( 'Here you can create own searchform order setting if you don\'t want to use global order.', 'myhome-core' ), array() ),
			'searchform_name'                   => wp_kses( __( 'Search form name', 'myhome-core' ), array() ),
			'available'                         => wp_kses( __( 'Available', 'myhome-core' ), array() ),
			'available_fields'                  => wp_kses( __( 'Available fields', 'myhome-core' ), array() ),
			'deleting_searchform'               => wp_kses( __( 'Deleting search form', 'myhome-core' ), array() ),
			'searchform'                        => wp_kses( __( 'Search form', 'myhome-core' ), array() ),
			'submit_property'                   => wp_kses( __( 'Submit property', 'myhome-core' ), array() ),
			'hidden'                            => wp_kses( __( 'Hidden', 'myhome-core' ), array() ),
			'settings'                          => wp_kses( __( 'Settings', 'myhome-core' ), array() ),
			'close'                             => wp_kses( __( 'Close', 'myhome-core' ), array() ),
			'instructions'                      => wp_kses( __( 'Instructions', 'myhome-core' ), array() ),
			'width'                             => wp_kses( __( 'Width', 'myhome-core' ), array() ),
			'allow_multiple_values'             => wp_kses( __( 'Allow multiple values', 'myhome-core' ), array() ),
			'default_location'                  => wp_kses( __( 'Default location', 'myhome-core' ), array() ),
			'single_property_page'              => wp_kses( __( 'Single property page', 'myhome-core' ), array() ),
			'searchform_horizontal_width'       => wp_kses( __( 'Search form horizontal full width', 'myhome-core' ), array() ),
			'basic_settings'                    => wp_kses( __( 'Basic settings', 'myhome-core' ), array() ),
			'hide_price_globally'               => wp_kses( __( 'Hide price globally', 'myhome-core' ), array() ),
			'text_when_price_not_set'           => wp_kses( __( 'Text displayed when price is not set', 'myhome-core' ), array() ),
			'currency'                          => wp_kses( __( 'Currency', 'myhome-core' ), array() ),
			'currency_sign'                     => wp_kses( __( 'Currency sign', 'myhome-core' ), array() ),
			'currency_sign_location'            => wp_kses( __( 'Currency sign location', 'myhome-core' ), array() ),
			'before_price'                      => wp_kses( __( 'Before price', 'myhome-core' ), array() ),
			'after_price'                       => wp_kses( __( 'After price', 'myhome-core' ), array() ),
			'thousands_separator'               => wp_kses( __( 'Thousands separator', 'myhome-core' ), array() ),
			'decimal_separator'                 => wp_kses( __( 'Decimal separator', 'myhome-core' ), array() ),
			'decimal'                           => wp_kses( __( 'Decimal', 'myhome-core' ), array() ),
			'sets_the_number_of_decimal_points' => wp_kses( __( 'Sets the number of decimal points', 'myhome-core' ), array() ),
			'add_new_currency'                  => wp_kses( __( 'Add new currency', 'myhome-core' ), array() ),
			'slug_is_piece_of_url'              => wp_kses( __( 'A "slug" is the piece of the URL. Please do not use special characters e.g. . = "  etc.', 'myhome-core' ), array() ),
			'parent_field'                      => wp_kses( __( 'Parent Field', 'myhome-core' ), array() ),
			'parent_field_description'          => wp_kses( __( 'It works only on frontend search form. Can be used to create field dependency e.g. when change city display different Neighbourhood. In this case "City" is parent', 'myhome-core' ), array() ),
			'display_on_single_property_page'   => wp_kses( __( 'Display on single property page', 'myhome-core' ), array() ),
			'show_as_link'                      => wp_kses( __( 'Display as a link on single property page', 'myhome-core' ), array() ),
			'display_on_card'                   => wp_kses( __( 'Display on the property cards', 'myhome-core' ), array() ),
			'display_on_card_description'       => wp_kses( __( 'e.g. search form or carousels', 'myhome-core' ), array() ),
			'use_as_tags_description'           => wp_kses( __( 'Field will be displayed in the same way as WordPress Post Tags in the right column on the backend property edition', 'myhome-core' ), array() ),
			'searchform_field_type'             => wp_kses( __( 'Search form field type', 'myhome-core' ), array() ),
			'placeholder_description'           => wp_kses( __( 'Placeholder is displayed in the search form field before the user enters a value', 'myhome-core' ), array() ),
			'suggestions'                       => wp_kses( __( 'Suggestions', 'myhome-core' ), array() ),
			'to'                                => wp_kses( __( 'To', 'myhome-core' ), array() ),
			'from'                              => wp_kses( __( 'From', 'myhome-core' ), array() ),
			'create_new_field'                  => wp_kses( __( 'Create new field', 'myhome-core' ), array() ),
			'order'                             => wp_kses( __( 'Order', 'myhome-core' ), array() ),
			'remove'                            => wp_kses( __( 'Remove', 'myhome-core' ), array() ),
			'create_new_agent_field'            => wp_kses( __( 'Create new agent field', 'myhome-core' ), array() ),
			'agent_fields'                      => wp_kses( __( 'Agent fields', 'myhome-core' ), array() ),
			'searchform_save'                   => wp_kses( __( 'Saving search form', 'myhome-core' ), array() ),
			'cancel'                            => wp_kses( __( 'Cancel', 'myhome-core' ), array() ),
			'property_fields'                   => wp_kses( __( 'Property fields', 'myhome-core' ), array() ),
			'create_new_property_field'         => wp_kses( __( 'Create new property field', 'myhome-core' ), array() ),
			'general'                           => wp_kses( __( 'General', 'myhome-core' ), array() ),
			'property_page'                     => wp_kses( __( 'Property Page', 'myhome-core' ), array() ),
			'agent'                             => wp_kses( __( 'Agent', 'myhome-core' ), array() ),
			'custom_search_forms'               => wp_kses( __( 'Custom search forms', 'myhome-core' ), array() ),
			'myhome_panel'                      => wp_kses( __( 'MyHome Panel', 'myhome-core' ), array() ),
			'unit_of_measure'                   => wp_kses( __( 'Unit of measure', 'myhome-core' ), array() ),
			'text_input'                        => wp_kses( __( 'Text input', 'myhome-core' ), array() ),
			'control_type'                      => wp_kses( __( 'Field type', 'myhome-core' ), array() ),
			'unit_of_measure_description'       => wp_kses( __( 'This option can be useful for sizes to add ft2 or m2. Please leave empty in other cases.', 'myhome-core' ), array() ),
			'suggestions_enabled'               => wp_kses( __( 'Enable suggestions', 'myhome-core' ), array() ),
			'suggest_init'                      => wp_kses( __( 'Suggest at start', 'myhome-core' ), array() ),
			'nothing'                           => wp_kses( __( 'Nothing', 'myhome-core' ), array() ),
			'redirect_on_select'                => wp_kses( __( 'Redirect when selected', 'myhome-core' ), array() ),
			'redirect_new_tab'                  => wp_kses( __( 'Open in new tab', 'myhome-core' ), array() ),
			'suggest_attributes'                => wp_kses( __( 'Suggest attributes', 'myhome-core' ), array() ),
			'price_range'                       => wp_kses( __( 'Use main price field as a range (from - to)', 'myhome-core' ), array() ),
			'assign_offer_type'                 => wp_kses( __( 'Assign offer type "display after" to default price', 'myhome-core' ), array() ),
			'checkbox_move'                     => wp_kses( __( 'Checkbox - move checked elements to the beginning of the list', 'myhome-core' ), array() ),
			'read_static'                       => wp_kses( __( 'Click here to read how to configure static vales', 'myhome-core' ), array() ),
			'parent_values'                     => wp_kses( __( 'Relationships based on already added properties', 'myhome-core' ), array() ),
			'parent_manual'                     => wp_kses( __( 'Relationships based on manual choice', 'myhome-core' ), array() ),
			'parent_type'                       => wp_kses( __( 'Parent type', 'myhome-core' ), array() ),
			'parent_type_description'           => wp_kses( __( 'Click here to read how it works', 'myhome-core' ), array() ),
			'slug_is_required'                  => wp_kses( __( 'Slug field is required', 'myhome-core' ), array() ),
			'allow_new_values'                  => wp_kses( __( 'Allow adding new values', 'myhome-core' ), array() ),
			'enable_autocomplete'               => wp_kses( __( 'Autocomplete', 'myhome-core' ), array() ),
			'paste_shortcode'                   => wp_kses( __( 'Paste shortcode', 'myhome-core' ), array() ),
			'location_part'                     => wp_kses( __( 'Google Map - geolocation', 'myhome-core' ), array() ),
			'location_type'                     => wp_kses( __( 'Auto-fill form values based on', 'myhome-core' ), array() ),
			'create_new_step'                   => wp_kses( __( 'Create new step', 'myhome-core' ), array() ),
			'set_step_name'                     => wp_kses( __( 'Set step name', 'myhome-core' ), array() ),
			'order_by'                          => wp_kses( __( 'Order by', 'myhome-core' ), array() ),
			'link'                              => wp_kses( __( 'Link', 'myhome-core' ), array() ),
		);
	}

	/**
	 * @return array
	 */
	public static function get_panel_settings() {
		return array();
	}

	/**
	 * @return array
	 */
	public static function get_panel() {
		return array(
			'username'                               => wp_kses( __( 'Username', 'myhome-core' ), array() ),
			'accept'                                 => wp_kses( __( 'I agree to the', 'myhome-core' ), array() ),
			'terms_of_service'                       => wp_kses( __( 'Terms of Service', 'myhome-core' ), array() ),
			'preview'                                => wp_kses( __( 'Preview', 'myhome-core' ), array() ),
			'discard'                                => wp_kses( __( 'Discard', 'myhome-core' ), array() ),
			'approve'                                => wp_kses( __( 'Approve', 'myhome-core' ), array() ),
			'trash'                                  => wp_kses( __( 'Trash', 'myhome-core' ), array() ),
			'restore'                                => wp_kses( __( 'Restore', 'myhome-core' ), array() ),
			'all'                                    => wp_kses( __( 'All', 'myhome-core' ), array() ),
			'moderation'                             => wp_kses( __( 'Moderation', 'myhome-core' ), array() ),
			'tour'                                   => wp_kses( __( 'Virtual tour', 'myhome-core' ), array() ),
			'tour_info'                              => wp_kses( __( 'Add embed code', 'myhome-core' ), array() ),
			'remove_file'                            => wp_kses( __( 'Remove file', 'myhome-core' ), array() ),
			'upload_profile_picture'                 => wp_kses( __( 'Upload profile picture', 'myhome-core' ), array() ),
			'upload_plan_image'                      => wp_kses( __( 'Drop plan image here or click to upload', 'myhome-core' ), array() ),
			'upload_image'                           => wp_kses( __( 'Upload image', 'myhome-core' ), array() ),
			'upload_images'                          => wp_kses( __( 'Upload images', 'myhome-core' ), array() ),
			'remove_image'                           => wp_kses( __( 'Remove image', 'myhome-core' ), array() ),
			'remove'                                 => wp_kses( __( 'Remove', 'myhome-core' ), array() ),
			'cancel_upload'                          => wp_kses( __( 'Cancel upload', 'myhome-core' ), array() ),
			'cancel_upload_confirm'                  => wp_kses( __( 'Are you sure you want to cancel this upload?', 'myhome-core' ), array() ),
			'image_upload_failed'                    => wp_kses( __( 'Image upload failed', 'myhome-core' ), array() ),
			'image_upload_wrong_type'                => wp_kses( __( 'You can\'t upload files of this type.', 'myhome-core' ), array() ),
			'pay_with_credit_card'                   => wp_kses( __( 'Pay with credit card', 'myhome-core' ), array() ),
			'pay_with_paypal'                        => wp_kses( __( 'Pay with PayPal', 'myhome-core' ), array() ),
			'you_can_login'                          => wp_kses( __( 'Thank you for registering. You can log in now.', 'myhome-core' ), array() ),
			'image'                                  => wp_kses( __( 'Image', 'myhome-core' ), array() ),
			'title'                                  => wp_kses( __( 'Title', 'myhome-core' ), array() ),
			'status'                                 => wp_kses( __( 'Status', 'myhome-core' ), array() ),
			'payment'                                => wp_kses( __( 'Payment', 'myhome-core' ), array() ),
			'edit'                                   => wp_kses( __( 'Edit', 'myhome-core' ), array() ),
			'log_in'                                 => wp_kses( __( 'Log in', 'myhome-core' ), array() ),
			'log_out'                                => wp_kses( __( 'Log out', 'myhome-core' ), array() ),
			'login'                                  => wp_kses( __( 'Login', 'myhome-core' ), array() ),
			'login2'                                 => apply_filters( 'myhome_panel_login_string', wp_kses( __( 'Login', 'myhome-core' ), array() ) ),
			'password'                               => wp_kses( __( 'Password', 'myhome-core' ), array() ),
			'enter_password'                         => wp_kses( __( 'Password', 'myhome-core' ), array() ),
			'enter_password_repeat'                  => wp_kses( __( 'Repeat password', 'myhome-core' ), array() ),
			'user_name'                              => wp_kses( __( 'user name', 'myhome-core' ), array() ),
			'email'                                  => wp_kses( __( 'E-mail', 'myhome-core' ), array() ),
			'name'                                   => wp_kses( __( 'Name', 'myhome-core' ), array() ),
			'public_name'                            => wp_kses( __( 'Public name', 'myhome-core' ), array() ),
			'welcome'                                => wp_kses( __( 'Welcome', 'myhome-core' ), array() ),
			'submit_property'                        => wp_kses( __( 'Submit property', 'myhome-core' ), array() ),
			'my_properties'                          => wp_kses( __( 'My properties', 'myhome-core' ), array() ),
			'view_my_profile'                        => wp_kses( __( 'View my profile', 'myhome-core' ), array() ),
			'phone_number'                           => wp_kses( __( 'Phone number', 'myhome-core' ), array() ),
			'profile_picture'                        => wp_kses( __( 'Profile picture', 'myhome-core' ), array() ),
			'add_image'                              => wp_kses( __( 'Add image', 'myhome-core' ), array() ),
			'set_image'                              => wp_kses( __( 'Set image', 'myhome-core' ), array() ),
			'facebook_profile_link'                  => wp_kses( __( 'Facebook profile link', 'myhome-core' ), array() ),
			'twitter_profile_link'                   => wp_kses( __( 'Twitter profile link', 'myhome-core' ), array() ),
			'instagram_profile_link'                 => wp_kses( __( 'Instagram profile link', 'myhome-core' ), array() ),
			'linkedin_profile_link'                  => wp_kses( __( 'Linkedin profile link', 'myhome-core' ), array() ),
			'update_profile'                         => wp_kses( __( 'Update profile', 'myhome-core' ), array() ),
			'register'                               => wp_kses( __( 'Register', 'myhome-core' ), array() ),
			'email_address'                          => wp_kses( __( 'email address', 'myhome-core' ), array() ),
			'edit_property'                          => wp_kses( __( 'Edit property', 'myhome-core' ), array() ),
			'update_property'                        => wp_kses( __( 'Update property', 'myhome-core' ), array() ),
			'description'                            => wp_kses( __( 'Description', 'myhome-core' ), array() ),
			'featured_image'                         => wp_kses( __( 'Featured image', 'myhome-core' ), array() ),
			'all_images'                             => wp_kses( __( 'All images', 'myhome-core' ), array() ),
			'plans'                                  => wp_kses( __( 'Plans', 'myhome-core' ), array() ),
			'add_plan'                               => wp_kses( __( 'Add plan', 'myhome-core' ), array() ),
			'delete'                                 => wp_kses( __( 'Delete', 'myhome-core' ), array() ),
			'address'                                => wp_kses( __( 'Address', 'myhome-core' ), array() ),
			'visit_my_profile'                       => wp_kses( __( 'View my profile', 'myhome-core' ), array() ),
			'reset_password'                         => wp_kses( __( 'reset password', 'myhome-core' ), array() ),
			'retrieve_password'                      => wp_kses( __( 'Reset password', 'myhome-core' ), array() ),
			'remember_me'                            => wp_kses( __( 'remember me', 'myhome-core' ), array() ),
			'empty_field'                            => wp_kses( __( 'Empty field', 'myhome-core' ), array() ),
			'no_properties'                          => wp_kses( __( 'You haven’t added any property yet', 'myhome-core' ), array() ),
			'no_properties_found'                    => wp_kses( __( 'No properties found', 'myhome-core' ), array() ),
			'yes'                                    => wp_kses( __( 'Yes', 'myhome-core' ), array() ),
			'no'                                     => wp_kses( __( 'No', 'myhome-core' ), array() ),
			'delete_property'                        => wp_kses( __( 'Are you sure you want to delete', 'myhome-core' ), array() ),
			'user_name_change'                       => wp_kses( __( 'Username ( cannot be changed )', 'myhome-core' ), array() ),
			'profile_updated'                        => wp_kses( __( 'Profile updated', 'myhome-core' ), array() ),
			'unknown_error'                          => wp_kses( __( 'Unknown error', 'myhome-core' ), array() ),
			'logged_in'                              => wp_kses( __( 'You are logged in', 'myhome-core' ), array() ),
			'logged_out'                             => wp_kses( __( 'You are logged out', 'myhome-core' ), array() ),
			'select_or_upload_media'                 => wp_kses( __( 'Select or upload', 'myhome-core' ), array() ),
			'use_this_media'                         => wp_kses( __( 'Use this media', 'myhome-core' ), array() ),
			'tags_instruction'                       => wp_kses( __( 'Use commas to separate', 'myhome-core' ), array() ),
			'awaiting_moderation'                    => wp_kses( __( 'This property is waiting for approval.', 'myhome-core' ), array() ),
			'make_payment'                           => wp_kses( __( 'Make a payment', 'myhome-core' ), array() ),
			'payed'                                  => wp_kses( __( 'payed', 'myhome-core' ), array() ),
			'pay'                                    => wp_kses( __( 'pay', 'myhome-core' ), array() ),
			'submit_thank_you'                       => wp_kses( __( 'Thank you for submitting your property information.', 'myhome-core' ), array() ),
			'submit_thank_you_mod'                   => wp_kses( __( 'Thank you for submitting your property information. Your property is waiting for approval.', 'myhome-core' ), array() ),
			'moderation_update'                      => wp_kses( __( 'If you edit your property, it won\'t be visible to the public until it is approved again.', 'myhome-core' ), array() ),
			'awaiting_payment'                       => wp_kses( __( 'Awaiting payment', 'myhome-core' ), array() ),
			'publish'                                => wp_kses( __( 'Publish', 'myhome-core' ), array() ),
			'pending'                                => wp_kses( __( 'Pending', 'myhome-core' ), array() ),
			'draft'                                  => wp_kses( __( 'Draft', 'myhome-core' ), array() ),
			'private'                                => wp_kses( __( 'Private', 'myhome-core' ), array() ),
			'address_auto_complete'                  => wp_kses( __( 'Set map marker without changing address field', 'myhome-core' ), array() ),
			'email_valid'                            => wp_kses( __( 'Field must be a valid email', 'myhome-core' ), array() ),
			'required_valid'                         => wp_kses( __( 'Field is required.', 'myhome-core' ), array() ),
			'numeric_valid'                          => wp_kses( __( 'Field may only contain numeric characters.', 'myhome-core' ), array() ),
			'change_password'                        => wp_kses( __( 'Change password', 'myhome-core' ), array() ),
			'old_password'                           => wp_kses( __( 'Old password', 'myhome-core' ), array() ),
			'new_password'                           => wp_kses( __( 'New password', 'myhome-core' ), array() ),
			'error'                                  => wp_kses( __( 'Error', 'myhome-core' ), array() ),
			'something_went_wrong'                   => wp_kses( __( 'Something went wrong!', 'myhome-core' ), array() ),
			'uploading'                              => wp_kses( __( 'Uploading', 'myhome-core' ), array() ),
			'processing'                             => wp_kses( __( 'Processing', 'myhome-core' ), array() ),
			'saving_changes'                         => wp_kses( __( 'Saving changes', 'myhome-core' ), array() ),
			'changes_saved'                          => wp_kses( __( 'Changes saved', 'myhome-core' ), array() ),
			'changing_password'                      => wp_kses( __( 'Password changed', 'myhome-core' ), array() ),
			'password_changed'                       => wp_kses( __( 'Password changes', 'myhome-core' ), array() ),
			'login_in_progress'                      => wp_kses( __( 'Login in progress...', 'myhome-core' ), array() ),
			'logout_in_progress'                     => wp_kses( __( 'Logout in progress...', 'myhome-core' ), array() ),
			'logout'                                 => wp_kses( __( 'Logout', 'myhome-core' ), array() ),
			'email_sent'                             => wp_kses( __( 'E-mail sent', 'myhome-core' ), array() ),
			'email_sent_if_exists'                   => wp_kses( __( 'If your email exists...', 'myhome-core' ), array() ),
			'email_invalid'                          => wp_kses( __( 'Provided email is invalid', 'myhome-core' ), array() ),
			'retrieve_password_email'                => wp_kses( __( 'Provide email to change password', 'myhome-core' ), array() ),
			'submit'                                 => wp_kses( __( 'Submit', 'myhome-core' ), array() ),
			'register_in_progress'                   => wp_kses( __( 'Registering in progress...', 'myhome-core' ), array() ),
			'password_required'                      => wp_kses( __( 'Password required', 'myhome-core' ), array() ),
			'field_required'                         => wp_kses( __( 'This field is required', 'myhome-core' ), array() ),
			'email_required'                         => wp_kses( __( 'E-mail required', 'myhome-core' ), array() ),
			'login_required'                         => wp_kses( __( 'Login required', 'myhome-core' ), array() ),
			'fill_required_fields'                   => wp_kses( __( 'Please fill required fields', 'myhome-core' ), array() ),
			'min_4_chars'                            => wp_kses( __( 'Min 4 chars', 'myhome-core' ), array() ),
			'registered_title'                       => wp_kses( __( 'Thank you for registering', 'myhome-core' ), array() ),
			'registered_text'                        => wp_kses( __( 'You can now log in to your account', 'myhome-core' ), array() ),
			'registered_text_activate'               => wp_kses( __( 'Check your email for confirmation link.', 'myhome-core' ), array() ),
			'load_property'                          => wp_kses( __( 'Loading property', 'myhome-core' ), array() ),
			'load_video'                             => wp_kses( __( 'Loading video', 'myhome-core' ), array() ),
			'are_you_sure'                           => wp_kses( __( 'Are you sure?', 'myhome-core' ), array() ),
			'yes_delete_it'                          => wp_kses( __( 'Yes, delete it!', 'myhome-core' ), array() ),
			'cancel'                                 => wp_kses( __( 'Cancel', 'myhome-core' ), array() ),
			'property_deleted'                       => wp_kses( __( 'Property deleted', 'myhome-core' ), array() ),
			'property_saving'                        => wp_kses( __( 'Saving property', 'myhome-core' ), array() ),
			'property_creating'                      => wp_kses( __( 'Loading new form', 'myhome-core' ), array() ),
			'you_are_logged_out'                     => wp_kses( __( 'You are now logged out', 'myhome-core' ), array() ),
			'payment_processing'                     => wp_kses( __( 'Payment processing', 'myhome-core' ), array() ),
			'image_uploaded'                         => wp_kses( __( 'Image uploaded', 'myhome-core' ), array() ),
			'ok'                                     => wp_kses( __( 'OK', 'myhome-core' ), array() ),
			'loaded'                                 => wp_kses( __( 'Loaded', 'myhome-core' ), array() ),
			'id'                                     => wp_kses( __( 'ID', 'myhome-core' ), array() ),
			'action'                                 => wp_kses( __( 'Action', 'myhome-core' ), array() ),
			'date'                                   => wp_kses( __( 'Added', 'myhome-core' ), array() ),
			'any'                                    => wp_kses( __( 'Any', 'myhome-core' ), array() ),
			'sort_by'                                => wp_kses( __( 'Sort by', 'myhome-core' ), array() ),
			'name_asc'                               => wp_kses( __( 'Name (ASC)', 'myhome-core' ), array() ),
			'name_desc'                              => wp_kses( __( 'Name (DESC)', 'myhome-core' ), array() ),
			'back_to_login'                          => wp_kses( __( 'Back to login', 'myhome-core' ), array() ),
			'pay_stripe'                             => wp_kses( __( 'Pay with Stripe Checkout', 'myhome-core' ), array() ),
			'activation_link_sent'                   => wp_kses( __( 'Activation link sent', 'myhome-core' ), array() ),
			'sending_activation_link'                => wp_kses( __( 'Sending activation link', 'myhome-core' ), array() ),
			'send_activation_link_again'             => wp_kses( __( 'Resend activation link', 'myhome-core' ), array() ),
			'your_account_is_now_active'             => wp_kses( __( 'Thank you for authenticating your registration, your account is now active', 'myhome-core' ), array() ),
			'this_link_was_already_used_or_expired'  => wp_kses( __( 'This activation link is expired or have already been used.', 'myhome-core' ), array() ),
			'validation_not_size_must_be_less_than'  => wp_kses( __( 'File size must be less than', 'myhome-core' ), array() ),
			'validation_field_is_required'           => wp_kses( __( 'field is required', 'myhome-core' ), array() ),
			'validation_field_must_be_at_least'      => wp_kses( __( 'field must be at least', 'myhome-core' ), array() ),
			'validation_characters'                  => wp_kses( __( 'characters.', 'myhome-core' ), array() ),
			'validation_field_must_be'               => wp_kses( __( 'field must be', 'myhome-core' ), array() ),
			'validation_field_must_be_image'         => wp_kses( __( 'field must be an image.', 'myhome-core' ), array() ),
			'validation_field_must_be_email'         => wp_kses( __( 'field must be a valid email.', 'myhome-core' ), array() ),
			'validation_confirmation_does_not_match' => wp_kses( __( 'confirmation does not match.', 'myhome-core' ), array() ),
			'validation_decimal'                     => wp_kses( __( 'field must be a number', 'myhome-core' ), array() ),
			'validation_integer'                     => wp_kses( __( 'field must be a whole number', 'myhome-core' ), array() ),
			'reset'                                  => wp_kses( __( 'Reset', 'myhome-core' ), array() ),
			'enter_your_email'                       => wp_kses( __( 'Enter your e-mail', 'myhome-core' ), array() ),
			'reset_password_success'                 => wp_kses( __( 'If your email address exists in our database, you will receive a password recovery link at your email address in a few minutes.', 'myhome-core' ), array() ),
			'reset_password_link_expired'            => wp_kses( __( 'Link expired', 'myhome-core' ), array() ),
			'reset_password_link_expired_text'       => wp_kses( __( 'Your reset password link expired.', 'myhome-core' ), array() ),
			'reset_password_new'                     => wp_kses( __( 'New password', 'myhome-core' ), array() ),
			'reset_password_new_text'                => wp_kses( __( 'A new password has been sent to your e-mail address.', 'myhome-core' ), array() ),
			'reset_password_error'                   => wp_kses( __( 'Error', 'myhome-core' ), array() ),
			'reset_password_error_text'              => wp_kses( __( 'Failure in sending mail. ', 'myhome-core' ), array() ),
			'account_activation_link_expired'        => wp_kses( __( 'Link Expired', 'myhome-core' ), array() ),
			'account_activation_link_expired_text'   => wp_kses( __( 'Account activation link expired. ', 'myhome-core' ), array() ),
			'account_send_activation_again'          => wp_kses( __( 'Send again', 'myhome-core' ), array() ),
			'account_send_activation_link'           => wp_kses( __( 'Send activation link', 'myhome-core' ), array() ),
			'account_send_activation_link_again'     => wp_kses( __( 'Send activation link again', 'myhome-core' ), array() ),
			'send'                                   => wp_kses( __( 'Send ', 'myhome-core' ), array() ),
			'account_activation_link_resend'         => wp_kses( __( 'Account inactive', 'myhome-core' ), array() ),
			'account_activation_link_resend_text'    => wp_kses( __( 'Check your email for the confirmation link.', 'myhome-core' ), array() ),
			'gallery'                                => wp_kses( __( 'Gallery', 'myhome-core' ), array() ),
			'continue'                               => wp_kses( __( 'Continue', 'myhome-core' ), array() ),
			'previous_step'                          => wp_kses( __( 'Previous step', 'myhome-core' ), array() ),
			'gallery_required'                       => wp_kses( __( 'The Gallery field is required.', 'myhome-core' ), array() ),
			'max_number_files'                       => wp_kses( __( 'Maximum number of files:', 'myhome-core' ), array() ),
			'attachment'                             => wp_kses( __( 'Attachment', 'myhome-core' ), array() ),
			'attachments'                            => wp_kses( __( 'Attachments', 'myhome-core' ), array() ),
			'attachment_name'                        => wp_kses( __( 'Attachment name', 'myhome-core' ), array() ),
			'upload_attachments'                     => wp_kses( __( 'Upload attachments', 'myhome-core' ), array() ),
			'plan'                                   => wp_kses( __( 'Plan', 'myhome-core' ), array() ),
			'plan_name'                              => wp_kses( __( 'Plan name', 'myhome-core' ), array() ),
			'upload_plans'                           => wp_kses( __( 'Upload plans', 'myhome-core' ), array() ),
			'attachments_required'                   => wp_kses( __( 'The Attachments field is required', 'myhome-core' ), array() ),
			'plans_required'                         => wp_kses( __( 'The Plans field is required', 'myhome-core' ), array() ),
			'value'                                  => wp_kses( __( 'Value', 'myhome-core' ), array() ),
			'name_additional'                        => wp_kses( __( 'Name (e.g. Roofing)', 'myhome-core' ), array() ),
			'value_additional'                       => wp_kses( __( 'Value (e.g. Wooden)', 'myhome-core' ), array() ),
			'additional_features_required'           => wp_kses( __( 'The additional features field is required.', 'myhome-core' ), array() ),
			'profile'                                => wp_kses( __( 'Profile', 'myhome-core' ), array() ),
			'close'                                  => wp_kses( __( 'Close', 'myhome-core' ), array() ),
			'confirm'                                => wp_kses( __( 'Confirm', 'myhome-core' ), array() ),
			'favorite_properties'                    => wp_kses( __( 'Favorite properties', 'myhome-core' ), array() ),
			'edit_profile'                           => wp_kses( __( 'Edit profile', 'myhome-core' ), array() ),
			'saved_searches'                         => wp_kses( __( 'Saved searches', 'myhome-core' ), array() ),
			'invite_agent'                           => wp_kses( __( 'Invite agent', 'myhome-core' ), array() ),
			'join_agency'                            => wp_kses( __( 'Join Agency', 'myhome-core' ), array() ),
			'decline'                                => wp_kses( __( 'Decline', 'myhome-core' ), array() ),
			're_generate'                            => wp_kses( __( 'Generate new key', 'myhome-core' ), array() ),
			'invitation_code'                        => wp_kses( __( 'Invitation code', 'myhome-core' ), array() ),
			'agents'                                 => wp_kses( __( 'Agents', 'myhome-core' ), array() ),
			'agency_invites'                         => wp_kses( __( 'Invitations from the agency', 'myhome-core' ), array() ),
			'my_dashboard'                           => wp_kses( __( 'My Dashboard', 'myhome-core' ), array() ),
			'account'                                => wp_kses( __( 'Account', 'myhome-core' ), array() ),
			'favorite'                               => wp_kses( __( 'Favorite', 'myhome-core' ), array() ),
			'properties_no_results'                  => wp_kses( __( 'No matching records found', 'myhome-core' ), array() ),
			'properties_no_data'                     => wp_kses( __( 'No data available', 'myhome-core' ), array() ),
			'properties_per_page'                    => wp_kses( __( 'Rows per page', 'myhome-core' ), array() ),
			'favorite_no_results'                    => wp_kses( __( 'No matching records found', 'myhome-core' ), array() ),
			'favorite_no_data'                       => wp_kses( __( 'No data available', 'myhome-core' ), array() ),
			'favorite_per_page'                      => wp_kses( __( 'Rows per page', 'myhome-core' ), array() ),
			'saved_searches_no_results'              => wp_kses( __( 'No matching records found', 'myhome-core' ), array() ),
			'saved_searches_no_data'                 => wp_kses( __( 'No data available', 'myhome-core' ), array() ),
			'saved_searches_per_page'                => wp_kses( __( 'Rows per page', 'myhome-core' ), array() ),
			'actions'                                => wp_kses( __( 'Actions', 'myhome-core' ), array() ),
			'created'                                => wp_kses( __( 'Created', 'myhome-core' ), array() ),
			'expire'                                 => wp_kses( __( 'Expire', 'myhome-core' ), array() ),
			'link'                                   => wp_kses( __( 'Link', 'myhome-core' ), array() ),
			'register_closed'                        => wp_kses( __( 'Register closed', 'myhome-core' ), array() ),
			'register_closed_text'                   => wp_kses( __( 'Register closed text', 'myhome-core' ), array() ),
			'login_error'                            => wp_kses( __( 'Login error', 'myhome-core' ), array() ),
			'login_error_text'                       => wp_kses( __( 'Unexpected error in the authentication system', 'myhome-core' ), array() ),
			'enter_location'                         => wp_kses( __( 'Enter a location', 'myhome-core' ), array() ),
			'video'                                  => wp_kses( __( 'Video', 'myhome-core' ), array() ),
			'add_new'                                => wp_kses( __( 'Add new', 'myhome-core' ), array() ),
			'add'                                    => wp_kses( __( 'Add', 'myhome-core' ), array() ),
			'list'                                   => wp_kses( __( 'List', 'myhome-core' ), array() ),
			'change_click'                           => wp_kses( __( 'Change address on map click', 'myhome-core' ), array() ),
			'location'                               => wp_kses( __( 'Location', 'myhome-core' ), array() ),
			'virtual_tour'                           => wp_kses( __( 'Virtual Tour', 'myhome-core' ), array() ),
			'additional_features'                    => wp_kses( __( 'Additional features', 'myhome-core' ), array() ),
			'no_agents'                              => wp_kses( __( 'You do not have any agents assigned to your agency', 'myhome-core' ), array() ),
			'agents_assigned'                        => wp_kses( __( 'List of agents assigned to your agency', 'myhome-core' ), array() ),
			'agents_code'                            => wp_kses( __( 'If agent type this code in his Profile Setting, will be assigned to your agency.', 'myhome-core' ), array() ),
			'connect_with'                           => wp_kses( __( 'Connect with', 'myhome-core' ), array() ),
			'invite_agent_type_email'                => wp_kses( __( 'Type email of a agent who is already registered. He needs to accept invitation in the profile settings.', 'myhome-core' ), array() ),
			'properties_dots'                        => wp_kses( __( 'Properties: ', 'myhome-core' ), array() ),
			'featured_properties_dots'               => wp_kses( __( 'Featured properties: ', 'myhome-core' ), array() ),
			'buy_package'                            => wp_kses( __( 'Buy package', 'myhome-core' ), array() ),
			'update_property_success'                => wp_kses( __( 'Property updated successfully', 'myhome-core' ), array() ),
			'edit_profile_upload_photo'              => wp_kses( __( 'Upload your profile photo', 'myhome-core' ), array() ),
			'edit_profile_additional_information'    => wp_kses( __( 'Additional information', 'myhome-core' ), array() ),
			'removed'                                => wp_kses( __( 'Removed', 'myhome-core' ), array() ),
			'sure_remove'                            => wp_kses( __( 'Are you sure you want to remove', 'myhome-core' ), array() ),
			'no_package_yet'                         => wp_kses( __( 'You do not have package yet', 'myhome-core' ), array() ),
			'buy_later'                              => wp_kses( __( 'Buy later', 'myhome-core' ), array() ),
			'choose_package'                         => wp_kses( __( 'Choose package', 'myhome-core' ), array() ),
			'agency_code'                            => wp_kses( __( 'Agency code', 'myhome-core' ), array() ),
			'agency_invitation'                      => wp_kses( __( 'Agency invitation', 'myhome-core' ), array() ),
			'account_assigned'                       => wp_kses( __( 'Your account is assigned to:', 'myhome-core' ), array() ),
		);
	}
}
